#ifndef GST_CU_CONSTRAINED_COLOR_COLUMN_DESC_HPP__
#define GST_CU_CONSTRAINED_COLOR_COLUMN_DESC_HPP__

#include "buildspec.h"

#include <string>

namespace GST
{
namespace ClientUtils
{
// Describes the column schema of a constrained color
enum class ConstrainedColorColumnSchema
{
	// constrained color with one hex (#RRGGBB) column
	Hex,
	// constrained color with rgb columns
	Rgb,
	// constrained color with rgba columns
	Rgba,
};

// Describes the columns that build a constrained color
class GST_API_EXPORT ConstrainedColorColumnDesc
{
public:
	// constrained color with one hex (#RRGGBB) column
	// hex type must be text
	ConstrainedColorColumnDesc(std::string hexColumn);
	// constrained color with rgb columns
	// column types must be either all integer or all float
	ConstrainedColorColumnDesc(std::string redColumn,
							   std::string greenColumn,
							   std::string blueColumn);
	// constrained color with rgba columns
	// column types must be either all integer or all float
	ConstrainedColorColumnDesc(std::string redColumn,
							   std::string greenColumn,
							   std::string blueColumn,
							   std::string alphaColumn);
	// returns the active column schema
	ConstrainedColorColumnSchema schema() const;
	// returns the name of the red, green, blue, alpha or hex column. Might be
	// empty if not set. See `schema` for which are active
	const std::string &redColumn() const;
	const std::string &greenColumn() const;
	const std::string &blueColumn() const;
	const std::string &alphaColumn() const;
	const std::string &hexColumn() const;

private:
	std::string m_redColumn;
	std::string m_greenColumn;
	std::string m_blueColumn;
	std::string m_alphaColumn;
	std::string m_hexColumn;
	ConstrainedColorColumnSchema m_schema;
};

} // namespace ClientUtils
} // namespace GST
#endif // GST_CU_CONSTRAINED_COLOR_COLUMN_DESC_HPP__
